/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.google.common.collect.ImmutableSet;
import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.AuthorityPlayersFixedButtonsList;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.components.SmartRadioButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.gui.components.RadioButton;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public class AuthorityMMMonitor
extends MusicManagerMonitor {
    private static final class_2960 AUTHORITY_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/authority.png");
    private static final class_2561 BACK_TEXT = new class_2588("gui.back");
    private static final class_2561 EXPULSION_BUTTON_TEXT = new class_2588("imp.button.expulsion").method_27692(class_124.field_1079);
    private static final class_2561 CANT_CHANGE_AUTHORITY = new class_2588("imp.text.cantChangeAuthority");
    private static final class_2561 READONLY_RDO_TEXT = new class_2588("imp.radioButton.readonly");
    private static final class_2561 MEMBER_RDO_TEXT = new class_2588("imp.radioButton.member");
    private static final class_2561 BAN_RDO_TEXT = new class_2588("imp.radioButton.ban");
    private static final class_2561 ADMIN_RDO_TEXT = new class_2588("imp.radioButton.admin");
    private final List<UUID> members = new ArrayList<UUID>();
    private List<MusicPlayList> cashPlayLists;
    private SmartRadioButton readOnlyRadio;
    private SmartRadioButton memberRadio;
    private SmartRadioButton banRadio;
    private SmartRadioButton adminRadio;
    private SmartButton expulsionButton;

    public AuthorityMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.addRenderWidget(new SmartButton(this.getStartX() + 5, this.getStartY() + 180, 87, 15, BACK_TEXT, n -> {
            if (this.getParentType() != null) {
                this.insMonitor(this.getParentType());
            }
        }));
        this.addRenderWidget(new AuthorityPlayersFixedButtonsList(this.getStartX() + 6, this.getStartY() + 23, 175, 135, 9, (class_2561)new class_2588("imp.fixedList.authorityPlayers"), this.members, new FixedButtonsList.PressEntry<UUID>(){

            public void onPressEntry(FixedButtonsList<UUID> fixedButtonsList, UUID uuid, int i, int i1) {
                AuthorityMMMonitor.this.setSelectedPlayer(uuid);
            }
        }, n -> n.equals(this.getSelectedPlayer())));
        Supplier<Set<RadioButton>> rdos = () -> ImmutableSet.of((Object)this.readOnlyRadio, (Object)this.memberRadio, (Object)this.adminRadio, (Object)this.banRadio);
        this.readOnlyRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 188, this.getStartY() + 47, READONLY_RDO_TEXT, n -> this.sendChangeAuthorityPacket(this.getSelectedPlayer(), AuthorityInfo.AuthorityType.READ_ONLY), rdos));
        this.readOnlyRadio.setSelected(this.getAuthorityType(this.getSelectedPlayer()) == AuthorityInfo.AuthorityType.READ_ONLY);
        this.memberRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 188, this.getStartY() + 72, MEMBER_RDO_TEXT, n -> this.sendChangeAuthorityPacket(this.getSelectedPlayer(), AuthorityInfo.AuthorityType.MEMBER), rdos));
        this.memberRadio.setSelected(this.getAuthorityType(this.getSelectedPlayer()) == AuthorityInfo.AuthorityType.MEMBER);
        this.banRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 188, this.getStartY() + 97, BAN_RDO_TEXT, n -> this.sendChangeAuthorityPacket(this.getSelectedPlayer(), AuthorityInfo.AuthorityType.BAN), rdos));
        this.banRadio.setSelected(this.getAuthorityType(this.getSelectedPlayer()) == AuthorityInfo.AuthorityType.BAN);
        this.adminRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 188, this.getStartY() + 122, ADMIN_RDO_TEXT, n -> this.sendChangeAuthorityPacket(this.getSelectedPlayer(), AuthorityInfo.AuthorityType.ADMIN), rdos));
        this.adminRadio.setSelected(this.getAuthorityType(this.getSelectedPlayer()) == AuthorityInfo.AuthorityType.READ_ONLY);
        this.readOnlyRadio.field_22764 = this.canEdit(this.getSelectedPlayer());
        this.memberRadio.field_22764 = this.canEdit(this.getSelectedPlayer());
        this.banRadio.field_22764 = this.canEdit(this.getSelectedPlayer());
        this.adminRadio.field_22764 = this.canEdit(this.getSelectedPlayer()) && this.canSetAdmin();
        this.expulsionButton = this.addRenderWidget(new SmartButton(this.getStartX() + 188, this.getStartY() + 147, 87, 15, EXPULSION_BUTTON_TEXT, n -> {
            this.sendChangeAuthorityPacket(this.getSelectedPlayer(), AuthorityInfo.AuthorityType.NONE);
            this.setSelectedPlayer(null);
        }));
        this.expulsionButton.field_22764 = this.canEdit(this.getSelectedPlayer());
        this.cashPlayLists = this.getSyncManager().getMyPlayList();
        this.updateMembers();
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtil.drawTexture((class_2960)AUTHORITY_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)((float)this.width / (this.getSelectedPlayer() != null ? 1.0f : 2.0f)), (float)this.height, (float)this.width, (float)this.height);
        UUID sp = this.getSelectedPlayer();
        if (sp != null) {
            OERenderUtil.drawPlayerFace((class_4587)poseStack, (UUID)sp, (float)(this.getStartX() + 189), (float)(this.getStartY() + 23), (float)21.0f);
            String str = OEClientUtil.getPlayerNameByUUID((UUID)sp).orElseGet(sp::toString);
            this.drawSmartFixedWidthText(poseStack, (class_2561)new class_2585(str), this.getStartX() + 212, this.getStartY() + 25, 150.0f);
            this.drawSmartFixedWidthText(poseStack, this.getAuthorityType(sp).getText(), this.getStartX() + 212, this.getStartY() + 35, 150.0f);
            if (!this.canEdit(sp)) {
                this.drawSmartText(poseStack, CANT_CHANGE_AUTHORITY, this.getStartX() + 188, this.getStartY() + 47);
            }
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtil.renderTextureSprite((class_2960)AUTHORITY_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)(monitorWidth / (this.getSelectedPlayer(blockEntity) != null ? 1.0f : 2.0f)), (float)monitorHeight, (float)0.0f, (float)0.0f, (float)((float)this.width / (this.getSelectedPlayer(blockEntity) != null ? 1.0f : 2.0f)), (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 5.0f, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, BACK_TEXT, true);
        UUID sp = this.getSelectedPlayer(blockEntity);
        if (sp != null) {
            this.renderPlayerFaceSprite(poseStack, multiBufferSource, sp, 189.0f, 23.0f, 0.004f, 21.0f, i, j, onPxW, onPxH, monitorHeight);
            String str = OEClientUtil.getPlayerNameByUUID((UUID)sp).orElseGet(sp::toString);
            this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)new class_2585(OERenderUtil.getWidthString((String)str, (float)130.0f, (String)"...")), 215.0f, 26.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
            this.renderSmartTextSprite(poseStack, multiBufferSource, this.getAuthorityType(blockEntity, sp).getText(), 215.0f, 36.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
            if (this.canEdit(blockEntity, sp)) {
                this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 188.0f, 47.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, READONLY_RDO_TEXT, this.getAuthorityType(blockEntity, this.getSelectedPlayer(blockEntity)) == AuthorityInfo.AuthorityType.READ_ONLY);
                this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 188.0f, 72.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, MEMBER_RDO_TEXT, this.getAuthorityType(blockEntity, this.getSelectedPlayer(blockEntity)) == AuthorityInfo.AuthorityType.MEMBER);
                this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 188.0f, 97.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, BAN_RDO_TEXT, this.getAuthorityType(blockEntity, this.getSelectedPlayer(blockEntity)) == AuthorityInfo.AuthorityType.BAN);
                this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 188.0f, 122.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, ADMIN_RDO_TEXT, this.getAuthorityType(blockEntity, this.getSelectedPlayer(blockEntity)) == AuthorityInfo.AuthorityType.ADMIN);
                this.renderSmartButtonSprite(poseStack, multiBufferSource, 188.0f, 147.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, EXPULSION_BUTTON_TEXT, true);
            } else {
                this.renderSmartTextSprite(poseStack, multiBufferSource, CANT_CHANGE_AUTHORITY, 188.0f, 48.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
            }
        }
        ArrayList<UUID> pls = new ArrayList<UUID>();
        MusicPlayList pl = this.getSelectedMusicPlayList(blockEntity);
        if (pl != null) {
            pls.addAll(pl.getAuthority().getPlayersAuthority().entrySet().stream().filter(n -> n.getValue() != AuthorityInfo.AuthorityType.NONE && n.getValue() != AuthorityInfo.AuthorityType.INVITATION).map(Map.Entry::getKey).toList());
        }
        this.renderFixedListSprite(poseStack, multiBufferSource, 6.0f, 23.0f, 0.004f, 175.0f, 135.0f, i, j, onPxW, onPxH, monitorHeight, pls, 9, (poseStack1, multiBufferSource1, x, y, z, w, h, i1, j1, entry) -> {
            this.renderSmartButtonBoxSprite(poseStack1, multiBufferSource1, x, y, z + 0.001f, w, h, i1, j1, onPxW, onPxH, monitorHeight, entry.equals(this.getSelectedPlayer(blockEntity)));
            this.renderPlayerFaceSprite(poseStack1, multiBufferSource1, (UUID)entry, x + 1.0f, y + 1.0f, z + 0.003f, h - 2.0f, i1, j1, onPxW, onPxH, monitorHeight);
            this.renderSmartTextSprite(poseStack1, multiBufferSource1, (class_2561)new class_2585(OERenderUtil.getWidthString((String)OEClientUtil.getPlayerNameByUUID((UUID)entry).orElseGet(entry::toString), (float)(w - (h + 7.0f)), (String)"...")), x + h + 3.0f, y + (h - 6.5f) / 2.0f, z + 0.003f, onPxW, onPxH, monitorHeight, i1);
        });
    }

    private void sendChangeAuthorityPacket(UUID playerID, AuthorityInfo.AuthorityType type) {
        if (playerID == null) {
            return;
        }
        MusicPlayList ps = this.getSelectedMusicPlayList();
        if (ps != null) {
            NetworkManager.sendToServer((class_2960)IMPPackets.MUSIC_PLAYLIST_CHANGE_AUTHORITY, (class_2540)new IMPPackets.MusicPlayListChangeAuthorityMessage(ps.getUuid(), playerID, type, BlockEntityExistence.getByBlockEntity((class_2586)this.getScreen().getBlockEntity())).toFBB());
        }
    }

    protected AuthorityInfo.AuthorityType getAuthorityType(UUID playerId) {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getAuthorityType(musicManagerBlockEntity, playerId);
        }
        return AuthorityInfo.AuthorityType.NONE;
    }

    protected AuthorityInfo.AuthorityType getAuthorityType(MusicManagerBlockEntity musicManagerBlockEntity, UUID playerId) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            return pl.getAuthority().getAuthorityType(playerId);
        }
        return AuthorityInfo.AuthorityType.NONE;
    }

    private boolean canEdit(UUID playerID) {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.canEdit(musicManagerBlockEntity, playerID);
        }
        return false;
    }

    private boolean canSetAdmin() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.canSetAdmin(musicManagerBlockEntity);
        }
        return false;
    }

    private boolean canSetAdmin(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            return pl.getAuthority().getAuthorityType(AuthorityMMMonitor.mc.field_1724.method_7334().getId()).isMoreOwner();
        }
        return false;
    }

    private boolean canEdit(MusicManagerBlockEntity musicManagerBlockEntity, UUID playerID) {
        if (playerID == null) {
            return false;
        }
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        if (pl != null) {
            AuthorityInfo.AuthorityType myAuth = pl.getAuthority().getAuthorityType(AuthorityMMMonitor.mc.field_1724.method_7334().getId());
            AuthorityInfo.AuthorityType tarAuth = pl.getAuthority().getAuthorityType(playerID);
            return myAuth.canChangeAuth(tarAuth);
        }
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.cashPlayLists != this.getSyncManager().getMyPlayList()) {
            this.cashPlayLists = this.getSyncManager().getMyPlayList();
            this.updateMembers();
        }
        this.readOnlyRadio.field_22764 = this.canEdit(this.getSelectedPlayer());
        this.memberRadio.field_22764 = this.canEdit(this.getSelectedPlayer());
        this.banRadio.field_22764 = this.canEdit(this.getSelectedPlayer());
        this.adminRadio.field_22764 = this.canEdit(this.getSelectedPlayer()) && this.canSetAdmin();
        this.expulsionButton.field_22764 = this.canEdit(this.getSelectedPlayer());
        this.readOnlyRadio.setSelected(this.getAuthorityType(this.getSelectedPlayer()) == AuthorityInfo.AuthorityType.READ_ONLY);
        this.memberRadio.setSelected(this.getAuthorityType(this.getSelectedPlayer()) == AuthorityInfo.AuthorityType.MEMBER);
        this.banRadio.setSelected(this.getAuthorityType(this.getSelectedPlayer()) == AuthorityInfo.AuthorityType.BAN);
        this.adminRadio.setSelected(this.getAuthorityType(this.getSelectedPlayer()) == AuthorityInfo.AuthorityType.ADMIN);
    }

    @Override
    @Nullable
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.DETAIL_PLAY_LIST;
    }

    private void updateMembers() {
        this.members.clear();
        MusicPlayList pl = this.getSelectedMusicPlayList();
        if (pl != null) {
            this.members.addAll(pl.getAuthority().getPlayersAuthority().entrySet().stream().filter(n -> n.getValue() != AuthorityInfo.AuthorityType.NONE && n.getValue() != AuthorityInfo.AuthorityType.INVITATION).map(Map.Entry::getKey).toList());
        }
    }

    protected MusicPlayList getSelectedMusicPlayList() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedMusicPlayList(musicManagerBlockEntity);
        }
        return null;
    }

    protected MusicPlayList getSelectedMusicPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<MusicPlayList> pls = this.getSyncManager().getMyPlayList();
        if (pls == null) {
            return null;
        }
        return pls.stream().filter(n -> n.getUuid().equals(this.getSelectedPlayList(musicManagerBlockEntity))).findFirst().orElse(null);
    }

    protected UUID getSelectedPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMySelectedPlayList();
    }

    protected UUID getSelectedPlayer() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedPlayer(musicManagerBlockEntity);
        }
        return null;
    }

    protected UUID getSelectedPlayer(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMySelectedPlayer();
    }

    protected void setSelectedPlayer(UUID playerId) {
        this.getScreen().insSelectedPlayer(playerId);
    }
}

